clc; clear all; close all; clear figure;

%nacteni souboru s definovanmi fuzzy mnoinami a inferennmi pravidly
fuzzy_reg = readfis('fuzzy_system');

%oteven seriovho portu
s = serial('COM9');
fopen(s);

%dan hodnota
zadana = 30;

%definice promnnch
humidity = 0;
regulacni_zasah = 0;
odchylka = 0;
old_odchylka = 0;
zmena_odchylky = 0;
old_regulacni_zasah = 0;

%normalizacni konstanty pro odchylku (ke), zmenu odchylky (kde) a zmenu
%zasahu (kdu)
ke = 20;
kde = 2;
kdu = 40;

tic;

%regulan smyka
for im=1:100
    
 
    prijato = fscanf(s);
    
    %preveden retezce z serioveho portu na vektor hodnot [humidity water flow ]
    data = hodnoty(prijato);
    
    humidity = data(1);
    waterON = data(2);
    flow = data(3);
    
    %vypocet odchylky a zmeny odchylky
    odchylka = zadana - humidity;
    
    %nastaven zmny odchylky v prvnm kroku regulace
    if im == 1, zmena_odchylky = 0;
    else
    zmena_odchylky = odchylka - old_odchylka;
    end
    
    %omezen, pokud odchylka je vt ne interval uren normalizac
    if (abs(odchylka) > (ke))
        if (odchylka < (ke)), regulacni_zasah = 180;
        else regulacni_zasah = -180; end;
    else
        
        %omezen, pokud zmna odchylka je vt ne interval uren normalizac
        if (abs(zmena_odchylky) > (kde))
            if (zmena_odchylky < 0), zmena_odchylky = -kde;
            else zmena_odchylky = kde; end;
        end   
                    
        %normalizace
        norm_odchylka = odchylka / ke;
        norm_zmena_odchylky = zmena_odchylky / kde;


        %vypocet normalizovane zmeny zasahu (fis)
        norm_zmena_zasahu = evalfis([norm_odchylka norm_zmena_odchylky], fuzzy_reg);

        %denormalizace
        zmena_zasahu = norm_zmena_zasahu * kdu;

        %vypocet akcniho zasahu
        regulacni_zasah = old_regulacni_zasah - zmena_zasahu;
    
    end
    
    %omezen aknho zsahu pro aktualizaci
    if regulacni_zasah > 220, regulacni_zasah = 220; end
    if regulacni_zasah < -220, regulacni_zasah = -220; end
    
    %aktualizace hodnot zasahu a odchylky pro dalsi krok
    old_regulacni_zasah = regulacni_zasah;
    old_odchylka = odchylka;
       
    
    %omezen aknho zsahu pro servo
    if regulacni_zasah > 180, regulacni_zasah = 180; end
    if regulacni_zasah < -180, regulacni_zasah = -180; end 
    
    
    %pevod aknho zsahu na int
    flow = int16(regulacni_zasah);
    
    %nastaven vody nebo dusku
    if flow < 0
        if waterON == 0
            fprintf(s,'Valves:Water'); 
        end
        fprintf(s,['ServoA:moveTo_',num2str(-flow)]);
    else
        if waterON == 1
            fprintf(s,'Valves:Air'); 
        end
        fprintf(s,['ServoA:moveTo_',num2str(flow)]);
    end
    
    %vektory uren k vykreslen
    Vhumidity(im) = humidity;
    Vregulacni_zasah(im) = regulacni_zasah;
    Vtime(im) = toc;
    Vodchylka(im) = odchylka;
    Vdodchylka(im) = zmena_odchylky;
    
    %vykreslen grafu regulace
    fig = figure(1);
  %set(fig,'units','normalized','outerposition',[0 0 1 1]);
    subplot(211)
    plot(Vtime,Vhumidity, '-o');
    title('Relativn vlhkost')
    ylabel('RH[%]');
    xlabel('cas[s]');

    %axis([0 3 0 80]);
    subplot(212)
    plot(Vtime,Vregulacni_zasah,'-o');
    title('Regulacni zasah')
    ylabel('Zasah');
    xlabel('cas[s]');
    
     pause(0.5);
    
end
%zaven seriovho portu
fclose(s);
